/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.match.ASTMatcher;
import org2.eclipse.php.internal.core.ast.nodes.AST;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.Block;
import org2.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org2.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org2.eclipse.php.internal.core.ast.nodes.Statement;
import org2.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.visitor.Visitor;

public class NamespaceDeclaration
extends Statement {
    private NamespaceName name;
    private Block body;
    private boolean bracketed = true;
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(NamespaceDeclaration.class, "name", NamespaceName.class, false, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(NamespaceDeclaration.class, "body", Block.class, false, true);
    public static final SimplePropertyDescriptor BRACKETED_PROPERTY = new SimplePropertyDescriptor(NamespaceDeclaration.class, "bracketed", Boolean.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(2);
        properyList.add(NAME_PROPERTY);
        properyList.add(BODY_PROPERTY);
        properyList.add(BRACKETED_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public NamespaceDeclaration(AST ast) {
        super(ast);
    }

    public NamespaceDeclaration(int start, int end, AST ast, NamespaceName name, Block body, boolean bracketed) {
        super(start, end, ast);
        if (!bracketed && name == null) {
            throw new IllegalArgumentException("Namespace name must not be null in an un-bracketed statement");
        }
        this.bracketed = bracketed;
        if (body == null) {
            body = new Block(end + 1, end + 1, ast, new ArrayList(), false);
        }
        body.setParent(this, BODY_PROPERTY);
        if (name != null) {
            name.setParent(this, NAME_PROPERTY);
        }
        this.name = name;
        this.body = body;
    }

    public boolean isBracketed() {
        return this.bracketed;
    }

    public void setBracketed(boolean bracketed) {
        this.preValueChange(BRACKETED_PROPERTY);
        this.bracketed = bracketed;
        this.postValueChange(BRACKETED_PROPERTY);
    }

    public void addStatement(Statement statement) {
        Block body = this.getBody();
        body.statements().add(statement);
        int statementEnd = statement.getEnd();
        int bodyStart = body.getStart();
        body.setSourceRange(bodyStart, statementEnd - bodyStart + 1);
        int namespaceStart = this.getStart();
        this.setSourceRange(namespaceStart, statementEnd - namespaceStart);
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block block) {
        Block oldChild = this.body;
        this.preReplaceChild(oldChild, block, BODY_PROPERTY);
        this.body = block;
        this.postReplaceChild(oldChild, block, BODY_PROPERTY);
    }

    public NamespaceName getName() {
        return this.name;
    }

    public void setName(NamespaceName name) {
        NamespaceName oldChild = this.name;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this.name = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        NamespaceName name = this.getName();
        if (name != null) {
            name.accept(visitor);
        }
        Block body = this.getBody();
        body.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        NamespaceName name = this.getName();
        if (name != null) {
            name.accept(visitor);
        }
        Block body = this.getBody();
        body.accept(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        NamespaceName name = this.getName();
        if (name != null) {
            name.accept(visitor);
        }
        Block body = this.getBody();
        body.accept(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<NamespaceDeclaration");
        this.appendInterval(buffer);
        buffer.append(" isBracketed='").append(this.bracketed).append("'>\n");
        NamespaceName name = this.getName();
        if (name != null) {
            name.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        Block body = this.getBody();
        body.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</NamespaceDeclaration>");
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        NamespaceName name = ASTNode.copySubtree(target, this.getName());
        Block body = ASTNode.copySubtree(target, this.getBody());
        boolean bracketed = this.isBracketed();
        NamespaceDeclaration result = new NamespaceDeclaration(this.getStart(), this.getEnd(), target, name, body, bracketed);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == BRACKETED_PROPERTY) {
            if (get) {
                return this.isBracketed();
            }
            this.setBracketed(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((NamespaceName)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }
}

